#ifndef _DRIVERLAYERCUSTOM_H_
#define _DRIVERLAYERCUSTOM_H_

#ifdef _DRIVER_CUSTOM

using namespace std;
#include <map>
#include <usb.h>
#include "DriverLayer.h"
#include "PlatformLayerLinux.h"

typedef struct {
    int serial;
    int qtyep;
    int devhnd;
    dscEndpoint eps[15];
} itemBoard;

class driverLayerCustom : public driverLayer {
    private:
        map<int,itemBoard> boards;
        int explenrecv;
        int pid;
        int vid;
        void findU4ABoards();
        int getInstance(int);
        int unBuildBoardPart(int);
        int unBuildDscPart(int);
        platformLayerLinux * pl;
    public:
        driverLayerCustom();
        ~driverLayerCustom();
        // Inicializacion
        int* getU4ABoards(int&);
        int qtyDsc(int);
        dscEndpoint* getEndpointDsc(int, int);
        // Utilizacion
        int open(int, int, usbin);
        int open(int, int, usbout);
        bool close(int);
        bool sendInt(int, char *, int, int);
        bool sendCtrl(int, char*, int, int);
        bool sendIso(int, char*, int, int);
        bool sendBulk(int, char*, int, int);
        char* receiveInt(int, int&, bool&, int);
        char* receiveCtrl(int, int&, bool&, int);
        char* receiveIso(int, int&, bool&, int);
        char* receiveBulk(int, int&, bool&, int);
};

#endif

#endif
